library(xlsx)
library(ggplot2)
library(cowplot)

Data.norm <- read.xlsx("Segment_Lengths_Volumes.xlsx", sheetIndex = 1, header = TRUE, row.names = 1)
Data.raw <- read.xlsx("Segment_Lengths_Volumes.xlsx", sheetIndex = 2, header = TRUE, row.names = 1)

lin.norm <- Data.norm[,1:16]
hull.norm <- Data.norm[,c(1,17:26)]
skin.norm <- Data.norm[,c(1,27:36)]

lin.raw <- Data.raw[,1:16]
hull.raw <- Data.raw[,c(1,17:26)]
skin.raw <- Data.raw[,c(1,27:36)]

##Linear Raw##

LR.hum <- ggplot(lin.raw, aes(x=Breed, y=L_Humerus, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow")) +
          labs(x = "", y = "Humerus Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.for <- ggplot(lin.raw, aes(x=Breed, y=L_Forearm, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Forearm Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.cmc <- ggplot(lin.raw, aes(x=Breed, y=L_CMC, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "CMC Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.man <- ggplot(lin.raw, aes(x=Breed, y=L_Manus, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Manus Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.tfl <- ggplot(lin.raw, aes(x=Breed, y=L_TotalFore, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Forelimb Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.thi <- ggplot(lin.raw, aes(x=Breed, y=L_Thigh, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Thigh Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.sha <- ggplot(lin.raw, aes(x=Breed, y=L_Shank, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Shank Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.tmt <- ggplot(lin.raw, aes(x=Breed, y=L_TMT, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "TMT Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.pes <- ggplot(lin.raw, aes(x=Breed, y=L_Pes, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Pes Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.thl <- ggplot(lin.raw, aes(x=Breed, y=L_TotalHind, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Hindlimb Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.nec <- ggplot(lin.raw, aes(x=Breed, y=L_Neck, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Neck Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.sho <- ggplot(lin.raw, aes(x=Breed, y=L_Shoulder, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Shoulder Width") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.ste <- ggplot(lin.raw, aes(x=Breed, y=L_Sternum, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Sternum Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.gad <- ggplot(lin.raw, aes(x=Breed, y=L_GA, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "G-A Distance") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LR.hip <- ggplot(lin.raw, aes(x=Breed, y=L_Hip, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Hip Width") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

tiff(filename = "Figure S2_1.tif", width = 222, height = 166, units = "mm", res = 600)

plot.new()

plot_grid(LR.hum, LR.for, LR.cmc, LR.man, LR.tfl,
          LR.thi, LR.sha, LR.tmt, LR.pes, LR.thl,
          LR.nec, LR.sho, LR.ste, LR.gad, LR.hip,
          labels = "AUTO", ncol = 5)

dev.off()



##Hulls Raw##

HR.hea <- ggplot(hull.raw, aes(x=Breed, y=H_Head, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Head Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HR.nec <- ggplot(hull.raw, aes(x=Breed, y=H_Neck, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Neck Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HR.tor <- ggplot(hull.raw, aes(x=Breed, y=H_Torso, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Torso Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HR.hum <- ggplot(hull.raw, aes(x=Breed, y=H_Humerus, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Humerus Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HR.for <- ggplot(hull.raw, aes(x=Breed, y=H_Forearm, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Forearm Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HR.man <- ggplot(hull.raw, aes(x=Breed, y=H_Manus, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Manus Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HR.thi <- ggplot(hull.raw, aes(x=Breed, y=H_Thigh, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Thigh Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HR.sha <- ggplot(hull.raw, aes(x=Breed, y=H_Shank, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Shank Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HR.tmt <- ggplot(hull.raw, aes(x=Breed, y=H_TMT, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "TMT Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HR.pes <- ggplot(hull.raw, aes(x=Breed, y=H_Pes, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Pes Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

tiff(filename = "Figure S2_2.tif", width = 222, height = 111, units = "mm", res = 600)

plot.new()

plot_grid(HR.hea, HR.nec, HR.tor, HR.hum, HR.for,
          HR.man, HR.thi, HR.sha, HR.tmt, HR.pes,
          labels = "AUTO", ncol = 5)

dev.off()


##Skins Raw##

SR.hea <- ggplot(skin.raw, aes(x=Breed, y=S_Head, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Head Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SR.nec <- ggplot(skin.raw, aes(x=Breed, y=S_Neck, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Neck Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SR.tor <- ggplot(skin.raw, aes(x=Breed, y=S_Torso, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Torso Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SR.hum <- ggplot(skin.raw, aes(x=Breed, y=S_Humerus, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Humerus Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SR.for <- ggplot(skin.raw, aes(x=Breed, y=S_Forearm, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Forearm Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SR.man <- ggplot(skin.raw, aes(x=Breed, y=S_Manus, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Manus Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SR.thi <- ggplot(skin.raw, aes(x=Breed, y=S_Thigh, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Thigh Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SR.sha <- ggplot(skin.raw, aes(x=Breed, y=S_Shank, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Shank Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SR.tmt <- ggplot(skin.raw, aes(x=Breed, y=S_TMT, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "TMT Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SR.pes <- ggplot(skin.raw, aes(x=Breed, y=S_Pes, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Pes Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

tiff(filename = "Figure S2_3.tif", width = 222, height = 111, units = "mm", res = 600)

plot.new()

plot_grid(SR.hea, SR.nec, SR.tor, SR.hum, SR.for,
          SR.man, SR.thi, SR.sha, SR.tmt, SR.pes,
          labels = "AUTO", ncol = 5)

dev.off()



##Linear Norm##

LN.hum <- ggplot(lin.norm, aes(x=Breed, y=L_Humerus, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Humerus Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.for <- ggplot(lin.norm, aes(x=Breed, y=L_Forearm, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Forearm Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.cmc <- ggplot(lin.norm, aes(x=Breed, y=L_CMC, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "CMC Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.man <- ggplot(lin.norm, aes(x=Breed, y=L_Manus, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Manus Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.tfl <- ggplot(lin.norm, aes(x=Breed, y=L_TotalFore, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Forelimb Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.thi <- ggplot(lin.norm, aes(x=Breed, y=L_Thigh, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Thigh Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.sha <- ggplot(lin.norm, aes(x=Breed, y=L_Shank, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Shank Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.tmt <- ggplot(lin.norm, aes(x=Breed, y=L_TMT, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "TMT Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.pes <- ggplot(lin.norm, aes(x=Breed, y=L_Pes, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Pes Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.thl <- ggplot(lin.norm, aes(x=Breed, y=L_TotalHind, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Hindlimb Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.nec <- ggplot(lin.norm, aes(x=Breed, y=L_Neck, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Neck Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.sho <- ggplot(lin.norm, aes(x=Breed, y=L_Shoulder, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Shoulder Width") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.ste <- ggplot(lin.norm, aes(x=Breed, y=L_Sternum, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Sternum Length") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.gad <- ggplot(lin.norm, aes(x=Breed, y=L_GA, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "G-A Distance") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

LN.hip <- ggplot(lin.norm, aes(x=Breed, y=L_Hip, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Hip Width") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

tiff(filename = "Figure S2_4.tif", width = 222, height = 166, units = "mm", res = 600)

plot.new()

plot_grid(LN.hum, LN.for, LN.cmc, LN.man, LN.tfl,
          LN.thi, LN.sha, LN.tmt, LN.pes, LN.thl,
          LN.nec, LN.sho, LN.ste, LN.gad, LN.hip,
          labels = "AUTO", ncol = 5)

dev.off()



##Hulls Norm##

HN.hea <- ggplot(hull.norm, aes(x=Breed, y=H_Head, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Head Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HN.nec <- ggplot(hull.norm, aes(x=Breed, y=H_Neck, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Neck Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HN.tor <- ggplot(hull.norm, aes(x=Breed, y=H_Torso, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Torso Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HN.hum <- ggplot(hull.norm, aes(x=Breed, y=H_Humerus, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Humerus Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HN.for <- ggplot(hull.norm, aes(x=Breed, y=H_Forearm, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Forearm Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HN.man <- ggplot(hull.norm, aes(x=Breed, y=H_Manus, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Manus Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HN.thi <- ggplot(hull.norm, aes(x=Breed, y=H_Thigh, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Thigh Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HN.sha <- ggplot(hull.norm, aes(x=Breed, y=H_Shank, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Shank Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HN.tmt <- ggplot(hull.norm, aes(x=Breed, y=H_TMT, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "TMT Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

HN.pes <- ggplot(hull.norm, aes(x=Breed, y=H_Pes, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Pes Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

tiff(filename = "Figure S2_5.tif", width = 222, height = 111, units = "mm", res = 600)

plot.new()

plot_grid(HN.hea, HN.nec, HN.tor, HN.hum, HN.for,
          HN.man, HN.thi, HN.sha, HN.tmt, HN.pes,
          labels = "AUTO", ncol = 5)

dev.off()


##Skins Raw##

SN.hea <- ggplot(skin.norm, aes(x=Breed, y=S_Head, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Head Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SN.nec <- ggplot(skin.norm, aes(x=Breed, y=S_Neck, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Neck Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SN.tor <- ggplot(skin.norm, aes(x=Breed, y=S_Torso, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Torso Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SN.hum <- ggplot(skin.norm, aes(x=Breed, y=S_Humerus, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Humerus Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SN.for <- ggplot(skin.norm, aes(x=Breed, y=S_Forearm, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "", y = "Forearm Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SN.man <- ggplot(skin.norm, aes(x=Breed, y=S_Manus, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Manus Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SN.thi <- ggplot(skin.norm, aes(x=Breed, y=S_Thigh, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Thigh Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SN.sha <- ggplot(skin.norm, aes(x=Breed, y=S_Shank, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Shank Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SN.tmt <- ggplot(skin.norm, aes(x=Breed, y=S_TMT, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "TMT Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

SN.pes <- ggplot(skin.norm, aes(x=Breed, y=S_Pes, fill=Breed)) + 
          geom_violin(trim = TRUE, lwd=1, width=1) +
          geom_boxplot(width=0.1, fill="white", lwd=1) +
          scale_fill_manual(values=c("sienna3", "skyblue4", "lightyellow2")) +
          labs(x = "Breed", y = "Pes Volume") +
          theme(legend.position="none") +
          theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(),panel.background = element_blank(), axis.line = element_line(colour = "black"))

tiff(filename = "Figure S2_6.tif", width = 222, height = 111, units = "mm", res = 600)

plot.new()

plot_grid(SN.hea, SN.nec, SN.tor, SN.hum, SN.for,
          SN.man, SN.thi, SN.sha, SN.tmt, SN.pes,
          labels = "AUTO", ncol = 5)

dev.off()